/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.lcdui;

import javax.microedition.lcdui.Display;
import org.netbeans.microedition.lcdui.AbstractInfoScreen;

public class SplashScreen
extends AbstractInfoScreen {
    private static final int DEFAULT_TIMEOUT = 5000;
    private int timeout = 5000;
    private boolean allowTimeoutInterrupt = true;
    private long currentDisplayTimestamp;

    public SplashScreen(Display display) throws IllegalArgumentException {
        super(display);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setAllowTimeoutInterrupt(boolean allow) {
        this.allowTimeoutInterrupt = allow;
    }

    public boolean isAllowTimeoutInterrupt() {
        return this.allowTimeoutInterrupt;
    }

    protected void keyPressed(int keyCode) {
        this.userAction();
    }

    protected void pointerPressed(int x, int y) {
        this.userAction();
    }

    protected void showNotify() {
        super.showNotify();
        this.currentDisplayTimestamp = System.currentTimeMillis();
        if (this.timeout > 0) {
            Watchdog w = new Watchdog(this.timeout, this.currentDisplayTimestamp);
            w.start();
        }
    }

    protected void hideNotify() {
        super.hideNotify();
        this.currentDisplayTimestamp = System.currentTimeMillis();
    }

    private void userAction() {
        if (this.allowTimeoutInterrupt) {
            this.switchToNextDisplayable();
        }
    }

    private void timeout() {
        this.switchToNextDisplayable();
    }

    private class Watchdog
    extends Thread {
        private int timeout;
        private long currentDisplayTimestamp;

        private Watchdog(int timeout, long currentDisplayTimestamp) {
            this.timeout = timeout;
            this.currentDisplayTimestamp = currentDisplayTimestamp;
        }

        public void run() {
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.currentDisplayTimestamp == SplashScreen.this.currentDisplayTimestamp) {
                SplashScreen.this.timeout();
            }
        }
    }
}

